<?php
/**
 * Admin page for WebView to App module
 *
 * @link       http://bundlewp.xyz
 * @since      1.0.0
 *
 * @package    Bundle_WP
 * @subpackage Bundle_WP/modules/webview-to-app/partials
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
?>

<div class="wrap">
    <h1><?php echo esc_html('WebView to App Settings'); ?></h1>
    
    <form action='options.php' method='post'>
        <?php
        settings_fields('bundle_wp_webview_to_app');
        do_settings_sections('bundle_wp_webview_to_app');
        submit_button();
        ?>
    </form>
    
    <div class="wvta-info-section" style="margin-top: 30px; background: #fff; padding: 15px; border-left: 4px solid #00a0d2;">
        <h2><?php _e('How to Use', 'bundle-wp'); ?></h2>
        <p><?php _e('This module converts your WordPress website into a Progressive Web App (PWA). When users visit your site on a mobile device, they\'ll see an option to "Add to Home Screen" which will install your site as an app on their device.', 'bundle-wp'); ?></p>
        
        <h3><?php _e('Instructions for Users', 'bundle-wp'); ?></h3>
        <ol>
            <li><?php _e('Visit the website in Chrome on Android or Safari on iOS', 'bundle-wp'); ?></li>
            <li><?php _e('For Chrome: Tap the menu button and select "Add to Home screen"', 'bundle-wp'); ?></li>
            <li><?php _e('For Safari: Tap the share button and select "Add to Home Screen"', 'bundle-wp'); ?></li>
            <li><?php _e('Confirm by tapping "Add"', 'bundle-wp'); ?></li>
        </ol>
        
        <p><?php _e('The website will now appear as an app on the user\'s home screen with the icon and name specified in the settings.', 'bundle-wp'); ?></p>
    </div>
</div>