/**
 * Register service worker for WebView to App module
 */
document.addEventListener('DOMContentLoaded', function() {
  if ('serviceWorker' in navigator) {
    window.addEventListener('load', function() {
      navigator.serviceWorker.register(webviewToAppVars.swPath)
        .then(function(registration) {
          console.log('WebView to App: Service Worker registered with scope:', registration.scope);
        })
        .catch(function(error) {
          console.log('WebView to App: Service Worker registration failed:', error);
        });
    });
  } else {
    console.log('WebView to App: Service Workers are not supported in this browser.');
  }
  
  // Add install prompt functionality
  let deferredPrompt;
  const installButton = document.createElement('button');
  installButton.style.display = 'none';
  installButton.className = 'webview-to-app-install-button';
  installButton.textContent = 'Install Web App';
  
  // Optional: Add the button to your page DOM if you want a custom install button
  // document.body.appendChild(installButton);
  
  window.addEventListener('beforeinstallprompt', (e) => {
    // Prevent Chrome 67 and earlier from automatically showing the prompt
    e.preventDefault();
    // Stash the event so it can be triggered later
    deferredPrompt = e;
    // Update UI to notify the user they can add to home screen
    installButton.style.display = 'block';
    
    // Optional: Show a custom UI element for installation
    installButton.addEventListener('click', (e) => {
      // Hide our user interface that shows our button
      installButton.style.display = 'none';
      // Show the prompt
      deferredPrompt.prompt();
      // Wait for the user to respond to the prompt
      deferredPrompt.userChoice.then((choiceResult) => {
        if (choiceResult.outcome === 'accepted') {
          console.log('User accepted the install prompt');
        } else {
          console.log('User dismissed the install prompt');
        }
        deferredPrompt = null;
      });
    });
  });
  
  // Track when the app is installed
  window.addEventListener('appinstalled', (evt) => {
    console.log('WebView to App: Application was installed to home screen.');
  });
});