<?php
/**
 * Provide a admin area view for the No Search Engine module
 *
 * @since      1.0.0
 * @package    Bundle_WP
 * @subpackage Bundle_WP/modules/no-search-engine/partials
 */

// Get the options
$options = get_option( 'bundle_wp_no_search_engine_options', array(
    'enabled' => false,
    'selected_items' => array(),
    'apply_to' => 'specific_items',
));
?>

<div class="wrap">
    <h1><?php esc_html_e( 'Don\'t Show on Search Engine', 'bundle-wp' ); ?></h1>
    
    <div class="bundle-wp-admin-container">
        <div class="bundle-wp-admin-header">
            <h2><?php esc_html_e( 'No Search Engine Settings', 'bundle-wp' ); ?></h2>
            <p><?php esc_html_e( 'Configure settings to prevent search engines from indexing specific content or your entire site.', 'bundle-wp' ); ?></p>
        </div>
        
        <form method="post" action="options.php">
            <?php settings_fields( 'bundle_wp_no_search_engine' ); ?>
            
            <div class="bundle-wp-admin-card">
                <h3><?php esc_html_e( 'Enable/Disable', 'bundle-wp' ); ?></h3>
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php esc_html_e( 'No Search Engine', 'bundle-wp' ); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" name="bundle_wp_no_search_engine_options[enabled]" value="1" <?php checked( true, $options['enabled'] ); ?> />
                                <?php esc_html_e( 'Enable No Search Engine functionality', 'bundle-wp' ); ?>
                            </label>
                        </td>
                    </tr>
                </table>
            </div>
            
            <div class="bundle-wp-admin-card">
                <h3><?php esc_html_e( 'Application Scope', 'bundle-wp' ); ?></h3>
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php esc_html_e( 'Apply To', 'bundle-wp' ); ?></th>
                        <td>
                            <label>
                                <input type="radio" name="bundle_wp_no_search_engine_options[apply_to]" value="entire_site" <?php checked( 'entire_site', $options['apply_to'] ); ?> />
                                <?php esc_html_e( 'Entire Website', 'bundle-wp' ); ?>
                            </label>
                            <br>
                            <label>
                                <input type="radio" name="bundle_wp_no_search_engine_options[apply_to]" value="specific_items" <?php checked( 'specific_items', $options['apply_to'] ); ?> />
                                <?php esc_html_e( 'Specific Posts/Pages', 'bundle-wp' ); ?>
                            </label>
                        </td>
                    </tr>
                </table>
            </div>
            
            <div id="bundle-wp-nse-specific-items" class="bundle-wp-admin-card" <?php echo $options['apply_to'] !== 'specific_items' ? 'style="display: none;"' : ''; ?>>
                <h3><?php esc_html_e( 'Select Specific Posts/Pages to Hide from Search Engines', 'bundle-wp' ); ?></h3>
                
                <div class="bundle-wp-items-list">
                    <?php
                    // Get all posts and pages
                    $posts = get_posts(array(
                        'post_type' => array('post', 'page'),
                        'numberposts' => -1,
                        'orderby' => 'title',
                        'order' => 'ASC',
                    ));
                    
                    if ($posts) : ?>
                        <table class="widefat">
                            <thead>
                                <tr>
                                    <th><?php esc_html_e( 'Select', 'bundle-wp' ); ?></th>
                                    <th><?php esc_html_e( 'Title', 'bundle-wp' ); ?></th>
                                    <th><?php esc_html_e( 'Type', 'bundle-wp' ); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($posts as $post) : ?>
                                    <tr>
                                        <td>
                                            <input type="checkbox" 
                                                name="bundle_wp_no_search_engine_options[selected_items][]" 
                                                value="<?php echo esc_attr($post->ID); ?>" 
                                                <?php checked( in_array( $post->ID, $options['selected_items'] ) ); ?> 
                                            />
                                        </td>
                                        <td><?php echo esc_html($post->post_title); ?></td>
                                        <td><?php echo esc_html(get_post_type_object($post->post_type)->labels->singular_name); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php else : ?>
                        <p><?php esc_html_e( 'No posts or pages found.', 'bundle-wp' ); ?></p>
                    <?php endif; ?>
                </div>
            </div>
            
            <?php submit_button(); ?>
        </form>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Toggle display of specific items section based on radio button selection
    $('input[name="bundle_wp_no_search_engine_options[apply_to]"]').change(function() {
        if ($(this).val() === 'specific_items') {
            $('#bundle-wp-nse-specific-items').show();
        } else {
            $('#bundle-wp-nse-specific-items').hide();
        }
    });
});
</script>