<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @since      1.0.0
 * @package    Bundle_WP
 */
?>

<div class="wrap">
    <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
    
    <div class="bundle-wp-admin-container">
        <div class="bundle-wp-admin-header">
            <h2><?php _e( 'Welcome to Bundle WP', 'bundle-wp' ); ?></h2>
            <p><?php _e( 'A collection of useful modules and tools for WordPress', 'bundle-wp' ); ?></p>
        </div>
        
        <div class="bundle-wp-admin-content">
            <div class="bundle-wp-admin-card">
                <h3><?php _e( 'Getting Started', 'bundle-wp' ); ?></h3>
                <p><?php _e( 'Bundle WP provides various modules to enhance your WordPress website. Navigate to the specific module pages using the submenu items on the left.', 'bundle-wp' ); ?></p>
            </div>
            
            <div class="bundle-wp-admin-card">
                <h3><?php _e( 'Plugin Information', 'bundle-wp' ); ?></h3>
                <ul>
                    <li><strong><?php _e( 'Version:', 'bundle-wp' ); ?></strong> <?php echo BUNDLE_WP_VERSION; ?></li>
                    <li><strong><?php _e( 'Website:', 'bundle-wp' ); ?></strong> <a href="http://bundlewp.xyz" target="_blank">bundlewp.xyz</a></li>
                </ul>
            </div>
        </div>
    </div>
</div>